# Finch Furniture.gsm - Manual Creation Instructions

## Purpose
Simple parametric library object that enables furniture scheduling/counting in Archicad.
The 3D geometry is minimal (just a box placeholder) - not meant for realistic visualization.

## How to Create

1. Open Archicad
2. File → Libraries and Objects → New Object
3. Create new GDL object named "Finch Furniture"
4. Add the following scripts:

### Master Script - Parameters
```gdl
! Parameters for furniture dimensions
A = 1.0      ! Width (X), meters
B = 0.6      ! Depth (Y), meters
ZZYZX = 0.8  ! Height (Z), meters
```

### 3D Script - Simple Box
```gdl
! Simple box placeholder (enables 3D visualization)
BLOCK A, B, ZZYZX
```

### 2D Symbol Script - Rectangle Outline
```gdl
! Simple rectangle outline (hidden by detailed polylines)
RECT2 0, 0, A, B

! Hotspots for reference points
HOTSPOT2 0, 0
HOTSPOT2 A, 0
HOTSPOT2 0, B
HOTSPOT2 A, B
```

5. Save as `Finch Furniture.gsm` in this `gsm/` folder
6. Test: Place manually in Archicad, verify it appears as a simple box

## Notes
- The 2D symbol (RECT2) will be visually hidden by the detailed polylines created separately
- The 3D box is just a placeholder for visualization
- Parameters A, B, ZZYZX will be set dynamically by FurnitureBuilder based on shape2d bounds
